module usestopwatch

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program creates a simple program that uses the stopwatch process. 
//  The program only has a menu to open the stopwatch and control it.
//  ********************************************************************************

import StdEnv, StdIO
import stopwatch

::  NoState
    =   NoState

Start :: *World -> *World
Start world
    #   (stopwatchid,world) = openRId world
    =   startIO NoState NoState [initialise stopwatchid] [] world

initialise :: (RId StopwatchCommands) (PSt .l .p) -> PSt .l .p
initialise stopwatchid ps
    #   ps          = openProcesses (stopwatch stopwatchid) ps
    #   (error,ps)  = openMenu NoState mdef ps
    |   error<>NoError
        =   closeProcess ps
    |   otherwise
        =   ps
where
    mdef    = Menu "Stopwatch"
                (   MenuItem "Reset"    [MenuFunction (noLS (send Reset))]
                :+: MenuItem "Pause"    [MenuFunction (noLS (send Pause))]
                :+: MenuItem "Continue" [MenuFunction (noLS (send Continue))]
                :+: MenuItem "Close"    [MenuFunction (noLS (send Close))]
                :+: MenuSeparator          []
                :+: MenuItem "Quit" [MenuFunction (noLS closeProcess)]
                )   []
    send msg ps
        #   (error,ps)  = syncSend stopwatchid msg ps
        |   case error of SendOk->False; _->True
            =   appPIO beep ps
        |   otherwise
            =   ps
